pointsToMatrix = function(x,y,matrixLength){
  
  round(x, digits = 2)
  round(y, digits = 2)
  
  dimX = dimY = matrixLength
  M = array(NA, dim = c(dimX,dimY))
  xSeq = seq(0,1,length.out = dimX + 1)[-(dimX + 1)]
  ySeq = seq(0,1,length.out = dimY + 1)[-(dimY + 1)]
  interval = round(mean(diff(xSeq)), digits = 2)
  for(i_x in 1:length(xSeq)){
    for(i_y in 1:length(ySeq)){
      xi = xSeq[i_x]
      yi = ySeq[i_y]
      
      inCell = which(y > yi & y <= round(yi + interval, digits = 2) &
                     x > xi & x <= round(xi + interval, digits = 2))
      M[i_x,i_y] = length(inCell)
      if(length(inCell) > 0){
        x = x[-inCell]
        y = y[-inCell]
      }
    }
  }
  
  M[M > 0] = 1
  return(M)
}

